 //src: http://country.io/iso3.json
var isoCodeConverterData = {"BD": "BGD", "BE": "BEL", "BF": "BFA", "BG": "BGR", "BA": "BIH", "BB": "BRB", "WF": "WLF", "BL": "BLM", "BM": "BMU", "BN": "BRN", "BO": "BOL", "BH": "BHR", "BI": "BDI", "BJ": "BEN", "BT": "BTN", "JM": "JAM", "BV": "BVT", "BW": "BWA", "WS": "WSM", "BQ": "BES", "BR": "BRA", "BS": "BHS", "JE": "JEY", "BY": "BLR", "BZ": "BLZ", "RU": "RUS", "RW": "RWA", "RS": "SRB", "TL": "TLS", "RE": "REU", "TM": "TKM", "TJ": "TJK", "RO": "ROU", "TK": "TKL", "GW": "GNB", "GU": "GUM", "GT": "GTM", "GS": "SGS", "GR": "GRC", "GQ": "GNQ", "GP": "GLP", "JP": "JPN", "GY": "GUY", "GG": "GGY", "GF": "GUF", "GE": "GEO", "GD": "GRD", "GB": "GBR", "GA": "GAB", "SV": "SLV", "GN": "GIN", "GM": "GMB", "GL": "GRL", "GI": "GIB", "GH": "GHA", "OM": "OMN", "TN": "TUN", "JO": "JOR", "HR": "HRV", "HT": "HTI", "HU": "HUN", "HK": "HKG", "HN": "HND", "HM": "HMD", "VE": "VEN", "PR": "PRI", "PS": "PSE", "PW": "PLW", "PT": "PRT", "SJ": "SJM", "PY": "PRY", "IQ": "IRQ", "PA": "PAN", "PF": "PYF", "PG": "PNG", "PE": "PER", "PK": "PAK", "PH": "PHL", "PN": "PCN", "PL": "POL", "PM": "SPM", "ZM": "ZMB", "EH": "ESH", "EE": "EST", "EG": "EGY", "ZA": "ZAF", "EC": "ECU", "IT": "ITA", "VN": "VNM", "SB": "SLB", "ET": "ETH", "SO": "SOM", "ZW": "ZWE", "SA": "SAU", "ES": "ESP", "ER": "ERI", "ME": "MNE", "MD": "MDA", "MG": "MDG", "MF": "MAF", "MA": "MAR", "MC": "MCO", "UZ": "UZB", "MM": "MMR", "ML": "MLI", "MO": "MAC", "MN": "MNG", "MH": "MHL", "MK": "MKD", "MU": "MUS", "MT": "MLT", "MW": "MWI", "MV": "MDV", "MQ": "MTQ", "MP": "MNP", "MS": "MSR", "MR": "MRT", "IM": "IMN", "UG": "UGA", "TZ": "TZA", "MY": "MYS", "MX": "MEX", "IL": "ISR", "FR": "FRA", "IO": "IOT", "SH": "SHN", "FI": "FIN", "FJ": "FJI", "FK": "FLK", "FM": "FSM", "FO": "FRO", "NI": "NIC", "NL": "NLD", "NO": "NOR", "NA": "NAM", "VU": "VUT", "NC": "NCL", "NE": "NER", "NF": "NFK", "NG": "NGA", "NZ": "NZL", "NP": "NPL", "NR": "NRU", "NU": "NIU", "CK": "COK", "XK": "XKX", "CI": "CIV", "CH": "CHE", "CO": "COL", "CN": "CHN", "CM": "CMR", "CL": "CHL", "CC": "CCK", "CA": "CAN", "CG": "COG", "CF": "CAF", "CD": "COD", "CZ": "CZE", "CY": "CYP", "CX": "CXR", "CR": "CRI", "CW": "CUW", "CV": "CPV", "CU": "CUB", "SZ": "SWZ", "SY": "SYR", "SX": "SXM", "KG": "KGZ", "KE": "KEN", "SS": "SSD", "SR": "SUR", "KI": "KIR", "KH": "KHM", "KN": "KNA", "KM": "COM", "ST": "STP", "SK": "SVK", "KR": "KOR", "SI": "SVN", "KP": "PRK", "KW": "KWT", "SN": "SEN", "SM": "SMR", "SL": "SLE", "SC": "SYC", "KZ": "KAZ", "KY": "CYM", "SG": "SGP", "SE": "SWE", "SD": "SDN", "DO": "DOM", "DM": "DMA", "DJ": "DJI", "DK": "DNK", "VG": "VGB", "DE": "DEU", "YE": "YEM", "DZ": "DZA", "US": "USA", "UY": "URY", "YT": "MYT", "UM": "UMI", "LB": "LBN", "LC": "LCA", "LA": "LAO", "TV": "TUV", "TW": "TWN", "TT": "TTO", "TR": "TUR", "LK": "LKA", "LI": "LIE", "LV": "LVA", "TO": "TON", "LT": "LTU", "LU": "LUX", "LR": "LBR", "LS": "LSO", "TH": "THA", "TF": "ATF", "TG": "TGO", "TD": "TCD", "TC": "TCA", "LY": "LBY", "VA": "VAT", "VC": "VCT", "AE": "ARE", "AD": "AND", "AG": "ATG", "AF": "AFG", "AI": "AIA", "VI": "VIR", "IS": "ISL", "IR": "IRN", "AM": "ARM", "AL": "ALB", "AO": "AGO", "AQ": "ATA", "AS": "ASM", "AR": "ARG", "AU": "AUS", "AT": "AUT", "AW": "ABW", "IN": "IND", "AX": "ALA", "AZ": "AZE", "IE": "IRL", "ID": "IDN", "UA": "UKR", "QA": "QAT", "MZ": "MOZ"};
var countriesArabic = {
"AF": " أفغانستان",
"AL": " ألبانيا",
"DZ": " الجزائر",
"AS": " ساموا الأمريكية",
"AD": " أندورا",
"AO": " أنغولا",
"AI": " أنغويلا",
"AQ": " القارة القطبية الجنوبية",
"AG": " أنتيغوا وباربودا",
"AR": " الأرجنتين",
"AM": " أرمينيا",
"AW": " أروبا",
"AU": " أستراليا",
"AT": " النمسا",
"AZ": " أذربيجان",
"BS": " باهاماس",
"BH": " البحرين",
"BD": " بنغلاديش",
"BB": " باربادوس",
"BY": " روسيا البيضاء",
"BE": " بلجيكا",
"BZ": " بليز",
"BJ": " بنين",
"BM": " برمودا",
"BT": " بوتان",
"BO": " بوليفيا",
"BA": " البوسنة والهرسك",
"BW": " بوتسوانا",
"BV": " جزيرة بوفيه",
"BR": " البرازيل",
"IO": " إقليم المحيط الهندي البريطاني",
"BN": " بروناي",
"BG": " بلغاريا",
"BF": " بوركينا فاسو",
"BI": " بوروندي",
"KH": " كمبوديا",
"CM": " الكاميرون",
"CA": " كندا",
"CV": " الرأس الأخضر",
"KY": " جزر كايمان",
"CF": " جمهورية أفريقيا الوسطى",
"TD": " تشاد",
"CL": " تشيلي",
"CN": " الصين",
"CX": " جزيرة عيد الميلاد",
"CC": " جزر كوكوس",
"CO": " كولومبيا",
"KM": " جزر القمر",
"CG": " جمهورية الكونغو",
"CD": " جمهورية الكونغو الديمقراطية",
"CK": " جزر كوك",
"CR": " كوستاريكا",
"CI": " ساحل العاج",
"HR": " كرواتيا",
"CU": " كوبا",
"CY": " قبرص",
"CZ": " جمهورية التشيك",
"DK": " الدنمارك",
"DJ": " جيبوتي",
"DM": " دومينيكا",
"DO": " جمهورية الدومينيكان",
"EC": " الإكوادور",
"EG": " مصر",
"SV": " السلفادور",
"GQ": " غينيا الاستوائية",
"ER": " إريتريا",
"EE": " إستونيا",
"ET": " إثيوبيا",
"FK": " جزر فوكلاند",
"FO": " جزر فارو",
"FJ": " فيجي",
"FI": " فنلندا",
"FR": " فرنسا",
"GF": " غويانا الفرنسية",
"PF": " بولينزيا الفرنسية",
"TF": " أراض فرنسية جنوبية وأنتارتيكية",
"GA": " الغابون",
"GM": " غامبيا",
"GE": " جورجيا",
"DE": " ألمانيا",
"GH": " غانا",
"GI": " جبل طارق",
"GR": " اليونان",
"GL": " جرينلاند",
"GD": " غرينادا",
"GP": " غوادلوب",
"GU": " غوام",
"GT": " غواتيمالا",
"GN": " غينيا",
"GW": " غينيا بيساو",
"GY": " غيانا",
"HT": " هايتي",
"HM": " جزيرة هيرد وجزر ماكدونالد",
"VA": "  الفاتيكان",
"HN": " هندوراس",
"HK": " هونغ كونغ",
"HU": " المجر",
"IS": " آيسلندا",
"IN": " الهند",
"ID": " إندونيسيا",
"IR": " إيران",
"IQ": " العراق",
"IE": " أيرلندا",
"IL": " إسرائيل",
"IT": " إيطاليا",
"JM": " جامايكا",
"JP": " اليابان",
"JO": " الأردن",
"KZ": " كازاخستان",
"KE": " كينيا",
"KI": " كيريباتي",
"KP": " كوريا الشمالية",
"KR": " كوريا الجنوبية",
"KW": " الكويت",
"KG": " قيرغيزستان",
"LA": " لاوس",
"LV": " لاتفيا",
"LB": " لبنان",
"LS": " ليسوتو",
"LR": " ليبيريا",
"LY": " ليبيا",
"LI": " ليختنشتاين",
"LT": " ليتوانيا",
"LU": " لوكسمبورغ",
"MO": " ماكاو",
"MK": " مقدونيا",
"MG": " مدغشقر",
"MW": " مالاوي",
"MY": " ماليزيا",
"MV": " جزر المالديف",
"ML": " مالي",
"MT": " مالطا",
"MH": " جزر مارشال",
"MQ": " مارتينيك",
"MR": " موريتانيا",
"MU": " موريشيوس",
"YT": " مايوت",
"MX": " المكسيك",
"FM": " ولايات ميكرونيسيا المتحدة",
"MD": " مولدوفا",
"MC": " موناكو",
"MN": " منغوليا",
"MS": " مونتسرات",
"MA": " المغرب",
"MZ": " موزمبيق",
"MM": " بورما",
"NA": " ناميبيا",
"NR": " ناورو",
"NP": " نيبال",
"NL": " هولندا",
"NC": " كاليدونيا الجديدة",
"NZ": " نيوزيلندا",
"NI": " نيكاراغوا",
"NE": " النيجر",
"NG": " نيجيريا",
"NU": " نييوي",
"NF": " جزيرة نورفولك",
"MP": " جزر ماريانا الشمالية",
"NO": " النرويج",
"OM": " عمان",
"PK": " باكستان",
"PW": " بالاو",
"PS": " فلسطين",
"PA": " بنما",
"PG": " بابوا غينيا الجديدة",
"PY": " باراغواي",
"PE": " بيرو",
"PH": " الفلبين",
"PN": " جزر بيتكيرن",
"PL": " بولندا",
"PT": " البرتغال",
"PR": " بورتوريكو",
"QA": " قطر",
"RE": " لا ريونيون",
"RO": " رومانيا",
"RU": " روسيا",
"RW": " رواندا",
"SH": " سانت هيلينا وأسينشين وتريستان دا كونا",
"KN": " سانت كيتس ونيفيس",
"LC": " سانت لوسيا",
"PM": " سان بيير وميكلون",
"VC": " سانت فينسنت والغرينادين",
"WS": " ساموا",
"SM": " سان مارينو",
"ST": " ساو تومي وبرينسيب",
"SA": " السعودية",
"SN": " السنغال",
"SC": " سيشل",
"SL": " سيراليون",
"SG": " سنغافورة",
"SK": " سلوفاكيا",
"SI": " سلوفينيا",
"SB": " جزر سليمان",
"SO": " الصومال",
"ZA": " جنوب أفريقيا",
"GS": " جورجيا الجنوبية وجزر ساندويتش الجنوبية",
"ES": " إسبانيا",
"LK": " سريلانكا",
"SD": " السودان",
"SR": " سورينام",
"SJ": " سفالبارد ويان ماين",
"SZ": " سوازيلاند",
"SE": " السويد",
"CH": " سويسرا",
"SY": " سوريا",
"TW": " تايوان",
"TJ": " طاجيكستان",
"TZ": " تانزانيا",
"TH": " تايلاند",
"TL": " تيمور الشرقية",
"TG": " توغو",
"TK": " توكيلاو",
"TO": " تونغا",
"TT": "ترينيداد وتوباغو",
"TN": " تونس",
"TR": " تركيا",
"TM": " تركمانستان",
"TC": " جزر توركس وكايكوس",
"TV": " توفالو",
"UG": " أوغندا",
"UA": " أوكرانيا",
"AE": " الإمارات العربية المتحدة",
"GB": " المملكة المتحدة",
"US": " الولايات المتحدة",
"UM": " جزر الولايات المتحدة",
"UY": " الأوروغواي",
"UZ": " أوزبكستان",
"VU": " فانواتو",
"VE": " فنزويلا",
"VN": " فيتنام",
"VG": " جزر العذراء البريطانية",
"VI": " جزر العذراء الأمريكية",
"WF": " والس وفوتونا",
"EH": " الصحراء الغربية",
"YE": " اليمن",
"ZM": " زامبيا",
"ZW": " زيمبابوي",
"AX": " جزر أولاند",
"BQ": " الجزر الكاريبية الهولندية",
"CW": " كوراساو",
"GG": " غيرنزي",
"IM": " جزيرة مان",
"JE": " جيرزي",
"ME": " الجبل الأسود",
"BL": " سان بارتيلمي",
"MF": " سانت مارتن (الجزء الفرنسي)",
"RS": " صربيا",
"SX": " سانت مارتن (الجزء الهولندي)",
"SS": " جنوب السودان",
"XK": " كوسوفو"
};

function isoToCountryName(_iso)
{
	return countriesArabic[_iso];
}


function convertDataToTwoLetterIsoCode(datamapsData) {
  var converted = {};
  for( var data in datamapsData ) {
    if ( datamapsData.hasOwnProperty(data) ) {
      converted[isoCodeConverterData[data]] = datamapsData[data];
    }
  }
  return converted;
}

function getKeyByValue(object, value) {
  return Object.keys(object).find(key => object[key] === value);
}

function convertToIsoCode(data) {
      return getKeyByValue(isoCodeConverterData,data);
}